<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Class Team controlador de los equipos que se registran en la aplicación
 */
class Team extends CI_Controller
{
    const PERPAGE = 9;
    const NUM_LINKS = 10;
    private $language;
    function __construct()
    {
        parent::__construct();
        if (!$this->session->has_userdata('user'))
              redirect(base_url() . '?msg=' . SESSION_EXPIRED, 'refresh');

        $this->load->model('teamModel');
        $this -> language = $this->session->userdata('language');
        include "application/src/Pagination.php";
    }

    /**
     * Funcion controladora de inicio donde muestra los equipos registrados
     */
    public function index()
    {
        $teams = $this->teamModel->getAllTeams();
        $data['teams'] = $this->teamModel->getTeamsBy(self::PERPAGE, $this->uri->segment(3));
        $data['text'] = $this->get_text_view_team($this -> language);
        $data['num_teams'] = sizeof($this -> teamModel -> getAllTeams());
        // Iniciamos la paginacion
        $pagination = new Pagination(base_url() . 'team/index', sizeof($teams), self::PERPAGE, self::NUM_LINKS);
        $pagination->init_pagination();

        $this->load->view('Estructura/header_principal');
        $this->load->view('Teams/teams', $data);
        $this->load->view('Estructura/footer');
    }

    /**
     * Funcion controlodora de la creacion de equipos.
     * Parametros pasados por medio de POST
     */
    public function addTeam()
    {
        $nombre = $this->input->get('nombreEquipo');
        $directorTecnico = $this->input->get('directorTecnico');
        $pais = $this->input->get('pais');
        $comunidadAutonoma = $this->input->get('comunidadAutonoma');
        $provincia = $this->input->get('provincia');

        $this->load->model('teamModel');
        $this->teamModel->existTeam($nombre) ?
            redirect(base_url() . 'team?msg=' . ERROR_TEAM_EXISTS, 'refresh') :
            $this->createTeam($nombre, $directorTecnico, $pais, $comunidadAutonoma, $provincia);

    }

    /**
     * Funcion controladora de eliminacion de equipos
     * Parametros pasados por POST
     */
    public function deleteTeam()
    {
        $teamName = $this->input->post('nombreEquipo');
        $this->load->model('teamModel');
        $this->teamModel->deleteTeam($teamName) ? redirect(base_url() . 'team?msg=' . SUCCESS_DELETE_TEAM, 'refresh') :
            redirect(base_url() . 'team?msg=' . ERROR_DELETE_TEAM, 'refresh');
    }

    /**
     * Ordena los equipos por provincia
     * @deprecated
     */
    public function showTeams()
    {
        $language = $this->session->userdata('language');
        $sortby = $this->input->get('sortby');
        $this->load->model('teamModel');
        $data['text'] = $this->get_text_view_team($language);
        $data['teams'] = $this->teamModel->sortTeamsBy($sortby);
        $this->load->view('Estructura/header_principal');
        $this->load->view('Teams/teams', $data);
        $this->load->view('Estructura/footer');
    }

    /**
     * Funcion controladora de la actualizacion de los datos del equipo
     * Parametros pasados por POST
     */
    public function updateTeam()
    {
        $nombre = $this->input->post('nombreEquipo');
        $directorTecnico = $this->input->post('directorTecnico');
        $pais = $this->input->post('pais');
        $comunidadAutonoma = $this->input->post('comunidadAutonoma');
        $provincia = $this->input->post('provincia');


        $this->load->model('teamModel');
        $this->teamModel->updateTeam($nombre, $directorTecnico, $pais, $comunidadAutonoma, $provincia) ? redirect(base_url() . 'team?msg=' . SUCCESS_UPDATE_TEAM, 'refresh') :
            redirect(base_url() . 'team?msg=' . ERROR_UPDATE_TEAM, 'refresh');

    }


    private function get_text_view_team($idiom)
    {
        $this->lang->load('team_lang', $idiom);
        $data['team_team_name'] = $this->lang->line('team_team_name');
        $data['team_technical_director'] = $this->lang->line('team_technical_director');
        $data['team_country'] = $this->lang->line('team_country');
        $data['team_autonomous_community'] = $this->lang->line('team_autonomous_community');
        $data['team_province'] = $this->lang->line('team_province');
        $data['team_create_btn'] = $this->lang->line('team_create_btn');
        $data['team_update'] = $this->lang->line('team_update');
        $data['team_delete'] = $this->lang->line('team_delete');
        $data['team_not_empty_fields'] = $this->lang->line('team_not_empty_fields');

        $data['team_info_num_teams'] = $this->lang->line('team_info_num_teams');
        $data['team_total_teams'] = $this->lang->line('team_total_teams');

        return $data;
    }

    private function createTeam($nombre, $directorTecnico, $pais, $comunidadAutonoma, $provincia)
    {
        $this->load->model('teamModel');
        if ($this->teamModel->createTeam($nombre, $directorTecnico, $pais, $comunidadAutonoma, $provincia))
            redirect(base_url() . 'team?msg=' . SUCCESS_CREATE_TEAM, 'refresh');
    }
}
